/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.net.URL;
import java.util.HashMap;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.Messages;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.spi.DefaultBrokenLinkProvider;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.filter.GraphicsNodeRable8Bit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class SVGBrokenLinkProvider
extends DefaultBrokenLinkProvider
implements ErrorConstants {
    static final String SVG_BROKEN_LINK_DOCUMENT_PROPERTY = "org.apache.batik.bridge.BrokenLinkDocument";
    UserAgent userAgent = new UserAgentAdapter();
    DocumentLoader loader = new DocumentLoader(this.userAgent);
    BridgeContext ctx = new BridgeContext(this.userAgent, this.loader);
    GraphicsNode gvtRoot = null;
    SVGDocument svgDoc;
    static /* synthetic */ Class class$org$apache$batik$bridge$SVGBrokenLinkProvider;

    public SVGBrokenLinkProvider() {
        Class cls = class$org$apache$batik$bridge$SVGBrokenLinkProvider == null ? (class$org$apache$batik$bridge$SVGBrokenLinkProvider = SVGBrokenLinkProvider.class$("org.apache.batik.bridge.SVGBrokenLinkProvider")) : class$org$apache$batik$bridge$SVGBrokenLinkProvider;
        URL blURL = cls.getResource("BrokenLink.svg");
        if (blURL == null) {
            return;
        }
        GVTBuilder builder = new GVTBuilder();
        try {
            this.svgDoc = (SVGDocument)this.loader.loadDocument(blURL.toString());
            this.gvtRoot = builder.build(this.ctx, this.svgDoc);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public Filter getBrokenLinkImage(Object base, String code, Object[] params) {
        if (this.gvtRoot != null) {
            String message = DefaultBrokenLinkProvider.formatMessage(base, code, params);
            Document doc = DOMUtilities.deepCloneDocument(this.svgDoc, this.svgDoc.getImplementation());
            Element infoE = doc.getElementById("More_About");
            Element title = doc.createElementNS("http://www.w3.org/2000/svg", "title");
            title.appendChild(doc.createTextNode(Messages.formatMessage("broken.link.title", null)));
            infoE.appendChild(title);
            Element desc = doc.createElementNS("http://www.w3.org/2000/svg", "desc");
            desc.appendChild(doc.createTextNode(message));
            infoE.appendChild(desc);
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("org.apache.batik.BrokenLinkImage", message);
            props.put(SVG_BROKEN_LINK_DOCUMENT_PROPERTY, doc);
            return new GraphicsNodeRable8Bit(this.gvtRoot, props);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SVG_BROKEN_LINK_DOCUMENT_PROPERTY = SVG_BROKEN_LINK_DOCUMENT_PROPERTY;
    }
}

