/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import org.apache.batik.dom.AbstractDOMImplementation;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.AbstractParentNode;
import org.apache.batik.dom.ExtendedNode;
import org.apache.batik.dom.events.DocumentEventSupport;
import org.apache.batik.dom.traversal.TraversalSupport;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.SoftDoublyIndexedTable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public abstract class AbstractDocument
extends AbstractParentNode
implements Document,
DocumentEvent,
DocumentTraversal,
Localizable {
    protected static final String RESOURCES = "org.apache.batik.dom.resources.Messages";
    protected transient LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.resources.Messages");
    protected transient DOMImplementation implementation;
    protected transient TraversalSupport traversalSupport;
    protected transient DocumentEventSupport documentEventSupport;
    protected transient boolean eventsEnabled;
    protected transient WeakHashMap elementsByTagNames;
    protected transient WeakHashMap elementsByTagNamesNS;

    protected AbstractDocument() {
    }

    protected AbstractDocument(DOMImplementation impl) {
        this.implementation = impl;
    }

    public void setLocale(Locale l) {
        this.localizableSupport.setLocale(l);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String key, Object[] args) throws MissingResourceException {
        return this.localizableSupport.formatMessage(key, args);
    }

    public boolean getEventsEnabled() {
        return this.eventsEnabled;
    }

    public void setEventsEnabled(boolean b) {
        this.eventsEnabled = b;
    }

    public String getNodeName() {
        return "#document";
    }

    public short getNodeType() {
        return 9;
    }

    public DocumentType getDoctype() {
        Node n = this.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 10) {
                return (DocumentType)n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    public void setDoctype(DocumentType dt) {
        if (dt != null) {
            this.appendChild(dt);
            ((ExtendedNode)((Object)dt)).setReadonly(true);
        }
    }

    public DOMImplementation getImplementation() {
        return this.implementation;
    }

    public Element getDocumentElement() {
        Node n = this.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1) {
                return (Element)n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        Node result;
        if (importedNode instanceof AbstractNode) {
            AbstractNode an = (AbstractNode)importedNode;
            return deep ? an.deepExport(an.cloneNode(false), this) : an.export(an.cloneNode(false), this);
        }
        switch (importedNode.getNodeType()) {
            case 1: {
                Element e = this.createElementNS(importedNode.getNamespaceURI(), importedNode.getNodeName());
                result = e;
                if (!e.hasAttributes()) break;
                NamedNodeMap attr = importedNode.getAttributes();
                int len = attr.getLength();
                int i = 0;
                while (i < len) {
                    Attr a = (Attr)attr.item(i);
                    if (a.getSpecified()) {
                        e.setAttributeNodeNS((Attr)this.importNode(a, true));
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                result = this.createAttributeNS(importedNode.getNamespaceURI(), importedNode.getNodeName());
                break;
            }
            case 3: {
                result = this.createTextNode(importedNode.getNodeValue());
                deep = false;
                break;
            }
            case 4: {
                result = this.createCDATASection(importedNode.getNodeValue());
                deep = false;
                break;
            }
            case 5: {
                result = this.createEntityReference(importedNode.getNodeName());
                break;
            }
            case 7: {
                result = this.createProcessingInstruction(importedNode.getNodeName(), importedNode.getNodeValue());
                deep = false;
                break;
            }
            case 8: {
                result = this.createComment(importedNode.getNodeValue());
                deep = false;
                break;
            }
            default: {
                throw this.createDOMException((short)9, "import.node", new Object[0]);
            }
        }
        if (deep) {
            Node n = importedNode.getFirstChild();
            while (n != null) {
                result.appendChild(this.importNode(n, true));
                n = n.getNextSibling();
            }
        }
        return result;
    }

    public Node cloneNode(boolean deep) {
        Document n = (Document)this.newNode();
        this.copyInto(n);
        if (deep) {
            Node c = this.getFirstChild();
            while (c != null) {
                n.appendChild(n.importNode(c, deep));
                c = c.getNextSibling();
            }
        }
        return n;
    }

    public AbstractParentNode.ElementsByTagName getElementsByTagName(Node n, String ln) {
        if (this.elementsByTagNames == null) {
            return null;
        }
        SoftDoublyIndexedTable t = (SoftDoublyIndexedTable)this.elementsByTagNames.get(n);
        if (t == null) {
            return null;
        }
        return (AbstractParentNode.ElementsByTagName)t.get(null, ln);
    }

    public void putElementsByTagName(Node n, String ln, AbstractParentNode.ElementsByTagName l) {
        SoftDoublyIndexedTable t;
        if (this.elementsByTagNames == null) {
            this.elementsByTagNames = new WeakHashMap(11);
        }
        if ((t = (SoftDoublyIndexedTable)this.elementsByTagNames.get(n)) == null) {
            t = new SoftDoublyIndexedTable();
            this.elementsByTagNames.put(n, t);
        }
        t.put(null, ln, l);
    }

    public AbstractParentNode.ElementsByTagNameNS getElementsByTagNameNS(Node n, String ns, String ln) {
        if (this.elementsByTagNamesNS == null) {
            return null;
        }
        SoftDoublyIndexedTable t = (SoftDoublyIndexedTable)this.elementsByTagNamesNS.get(n);
        if (t == null) {
            return null;
        }
        return (AbstractParentNode.ElementsByTagNameNS)t.get(ns, ln);
    }

    public void putElementsByTagNameNS(Node n, String ns, String ln, AbstractParentNode.ElementsByTagNameNS l) {
        SoftDoublyIndexedTable t;
        if (this.elementsByTagNamesNS == null) {
            this.elementsByTagNamesNS = new WeakHashMap(11);
        }
        if ((t = (SoftDoublyIndexedTable)this.elementsByTagNamesNS.get(n)) == null) {
            t = new SoftDoublyIndexedTable();
            this.elementsByTagNamesNS.put(n, t);
        }
        t.put(ns, ln, l);
    }

    public Event createEvent(String eventType) throws DOMException {
        if (this.documentEventSupport == null) {
            this.documentEventSupport = ((AbstractDOMImplementation)this.implementation).createDocumentEventSupport();
        }
        return this.documentEventSupport.createEvent(eventType);
    }

    public NodeIterator createNodeIterator(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) throws DOMException {
        if (this.traversalSupport == null) {
            this.traversalSupport = new TraversalSupport();
        }
        return this.traversalSupport.createNodeIterator(this, root, whatToShow, filter, entityReferenceExpansion);
    }

    public TreeWalker createTreeWalker(Node root, int whatToShow, NodeFilter filter, boolean entityReferenceExpansion) throws DOMException {
        return TraversalSupport.createTreeWalker(this, root, whatToShow, filter, entityReferenceExpansion);
    }

    public void detachNodeIterator(NodeIterator it) {
        this.traversalSupport.detachNodeIterator(it);
    }

    public void nodeToBeRemoved(Node node) {
        if (this.traversalSupport != null) {
            this.traversalSupport.nodeToBeRemoved(node);
        }
    }

    protected AbstractDocument getCurrentDocument() {
        return this;
    }

    protected Node export(Node n, Document d) {
        throw this.createDOMException((short)9, "import.document", new Object[0]);
    }

    protected Node deepExport(Node n, Document d) {
        throw this.createDOMException((short)9, "import.document", new Object[0]);
    }

    protected Node copyInto(Node n) {
        super.copyInto(n);
        AbstractDocument ad = (AbstractDocument)n;
        ad.implementation = this.implementation;
        ad.localizableSupport = new LocalizableSupport(RESOURCES);
        return n;
    }

    protected Node deepCopyInto(Node n) {
        super.deepCopyInto(n);
        AbstractDocument ad = (AbstractDocument)n;
        ad.implementation = this.implementation;
        ad.localizableSupport = new LocalizableSupport(RESOURCES);
        return n;
    }

    protected void checkChildType(Node n, boolean replace) {
        short t = n.getNodeType();
        switch (t) {
            case 1: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(t), n.getNodeName()});
            }
        }
        if (!replace && t == 1 && this.getDocumentElement() != null || t == 10 && this.getDoctype() != null) {
            throw this.createDOMException((short)3, "child.type", new Object[]{new Integer(this.getNodeType()), this.getNodeName(), new Integer(t), n.getNodeName()});
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.implementation.getClass().getName());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.localizableSupport = new LocalizableSupport(RESOURCES);
        Class<?> c = Class.forName((String)s.readObject());
        try {
            Method m = c.getMethod("getDOMImplementation", null);
            this.implementation = (DOMImplementation)m.invoke(null, null);
        }
        catch (Exception e) {
            try {
                this.implementation = (DOMImplementation)c.newInstance();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    static {
        RESOURCES = RESOURCES;
    }
}

