/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.swing.Messages;
import org.apache.batik.swing.gvt.AbstractImageZoomInteractor;
import org.apache.batik.swing.gvt.AbstractPanInteractor;
import org.apache.batik.swing.gvt.AbstractResetTransformInteractor;
import org.apache.batik.swing.gvt.AbstractRotateInteractor;
import org.apache.batik.swing.gvt.AbstractZoomInteractor;
import org.apache.batik.swing.gvt.Interactor;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.svg.JSVGComponent;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.util.XMLConstants;
import org.apache.batik.util.gui.JErrorPane;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;

public class JSVGCanvas
extends JSVGComponent {
    public static final String SCROLL_RIGHT_ACTION = "ScrollRight";
    public static final String SCROLL_LEFT_ACTION = "ScrollLeft";
    public static final String SCROLL_UP_ACTION = "ScrollUp";
    public static final String SCROLL_DOWN_ACTION = "ScrollDown";
    public static final String FAST_SCROLL_RIGHT_ACTION = "FastScrollRight";
    public static final String FAST_SCROLL_LEFT_ACTION = "FastScrollLeft";
    public static final String FAST_SCROLL_UP_ACTION = "FastScrollUp";
    public static final String FAST_SCROLL_DOWN_ACTION = "FastScrollDown";
    public static final String ZOOM_IN_ACTION = "ZoomIn";
    public static final String ZOOM_OUT_ACTION = "ZoomOut";
    public static final String RESET_TRANSFORM_ACTION = "ResetTransform";
    private boolean isZoomInteractorEnabled = true;
    private boolean isImageZoomInteractorEnabled = true;
    private boolean isPanInteractorEnabled = true;
    private boolean isRotateInteractorEnabled = true;
    private boolean isResetTransformInteractorEnabled = true;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected String uri;
    protected LocationListener locationListener = null;
    protected Interactor zoomInteractor = new AbstractZoomInteractor(){

        public boolean startInteraction(InputEvent ie) {
            int mods = ie.getModifiers();
            return ie.getID() == 501 && (mods & 0x10) != 0 && (mods & 2) != 0;
        }
    };
    protected Interactor imageZoomInteractor = new AbstractImageZoomInteractor(){

        public boolean startInteraction(InputEvent ie) {
            int mods = ie.getModifiers();
            return ie.getID() == 501 && (mods & 4) != 0 && (mods & 1) != 0;
        }
    };
    protected Interactor panInteractor = new AbstractPanInteractor(){

        public boolean startInteraction(InputEvent ie) {
            int mods = ie.getModifiers();
            return ie.getID() == 501 && (mods & 0x10) != 0 && (mods & 1) != 0;
        }
    };
    protected Interactor rotateInteractor = new AbstractRotateInteractor(){

        public boolean startInteraction(InputEvent ie) {
            int mods = ie.getModifiers();
            return ie.getID() == 501 && (mods & 4) != 0 && (mods & 2) != 0;
        }
    };
    protected Interactor resetTransformInteractor = new AbstractResetTransformInteractor(){

        public boolean startInteraction(InputEvent ie) {
            int mods = ie.getModifiers();
            return ie.getID() == 500 && (mods & 4) != 0 && (mods & 1) != 0 && (mods & 2) != 0;
        }
    };

    public JSVGCanvas() {
        this(null, true, true);
    }

    public JSVGCanvas(SVGUserAgent ua, boolean eventsEnabled, boolean selectableText) {
        super(ua, eventsEnabled, selectableText);
        this.setPreferredSize(new Dimension(200, 200));
        this.setMinimumSize(new Dimension(100, 100));
        List intl = this.getInteractors();
        intl.add(this.zoomInteractor);
        intl.add(this.imageZoomInteractor);
        intl.add(this.panInteractor);
        intl.add(this.rotateInteractor);
        intl.add(this.resetTransformInteractor);
        this.installActions();
        if (eventsEnabled) {
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent evt) {
                    JSVGCanvas.this.requestFocus();
                }
            });
            this.installKeyboardActions();
        }
    }

    protected void installActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put(SCROLL_RIGHT_ACTION, new ScrollRightAction(10));
        actionMap.put(SCROLL_LEFT_ACTION, new ScrollLeftAction(10));
        actionMap.put(SCROLL_UP_ACTION, new ScrollUpAction(10));
        actionMap.put(SCROLL_DOWN_ACTION, new ScrollDownAction(10));
        actionMap.put(FAST_SCROLL_RIGHT_ACTION, new ScrollRightAction(30));
        actionMap.put(FAST_SCROLL_LEFT_ACTION, new ScrollLeftAction(30));
        actionMap.put(FAST_SCROLL_UP_ACTION, new ScrollUpAction(30));
        actionMap.put(FAST_SCROLL_DOWN_ACTION, new ScrollDownAction(30));
        actionMap.put(ZOOM_IN_ACTION, new ZoomInAction());
        actionMap.put(ZOOM_OUT_ACTION, new ZoomOutAction());
        actionMap.put(RESET_TRANSFORM_ACTION, new ResetTransformAction());
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        KeyStroke key = KeyStroke.getKeyStroke(39, 0);
        inputMap.put(key, SCROLL_RIGHT_ACTION);
        key = KeyStroke.getKeyStroke(37, 0);
        inputMap.put(key, SCROLL_LEFT_ACTION);
        key = KeyStroke.getKeyStroke(38, 0);
        inputMap.put(key, SCROLL_UP_ACTION);
        key = KeyStroke.getKeyStroke(40, 0);
        inputMap.put(key, SCROLL_DOWN_ACTION);
        key = KeyStroke.getKeyStroke(39, 1);
        inputMap.put(key, FAST_SCROLL_RIGHT_ACTION);
        key = KeyStroke.getKeyStroke(37, 1);
        inputMap.put(key, FAST_SCROLL_LEFT_ACTION);
        key = KeyStroke.getKeyStroke(38, 1);
        inputMap.put(key, FAST_SCROLL_UP_ACTION);
        key = KeyStroke.getKeyStroke(40, 1);
        inputMap.put(key, FAST_SCROLL_DOWN_ACTION);
        key = KeyStroke.getKeyStroke(73, 2);
        inputMap.put(key, ZOOM_IN_ACTION);
        key = KeyStroke.getKeyStroke(79, 2);
        inputMap.put(key, ZOOM_OUT_ACTION);
        key = KeyStroke.getKeyStroke(84, 2);
        inputMap.put(key, RESET_TRANSFORM_ACTION);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propertyName, pcl);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propertyName, pcl);
    }

    public void setEnableZoomInteractor(boolean b) {
        if (this.isZoomInteractorEnabled != b) {
            boolean oldValue = this.isZoomInteractorEnabled;
            this.isZoomInteractorEnabled = b;
            if (this.isZoomInteractorEnabled) {
                this.getInteractors().add(this.zoomInteractor);
            } else {
                this.getInteractors().remove(this.zoomInteractor);
            }
            this.pcs.firePropertyChange("enableZoomInteractor", oldValue, b);
        }
    }

    public boolean getEnableZoomInteractor() {
        return this.isZoomInteractorEnabled;
    }

    public void setEnableImageZoomInteractor(boolean b) {
        if (this.isImageZoomInteractorEnabled != b) {
            boolean oldValue = this.isImageZoomInteractorEnabled;
            this.isImageZoomInteractorEnabled = b;
            if (this.isImageZoomInteractorEnabled) {
                this.getInteractors().add(this.imageZoomInteractor);
            } else {
                this.getInteractors().remove(this.imageZoomInteractor);
            }
            this.pcs.firePropertyChange("enableImageZoomInteractor", oldValue, b);
        }
    }

    public boolean getEnableImageZoomInteractor() {
        return this.isImageZoomInteractorEnabled;
    }

    public void setEnablePanInteractor(boolean b) {
        if (this.isPanInteractorEnabled != b) {
            boolean oldValue = this.isPanInteractorEnabled;
            this.isPanInteractorEnabled = b;
            if (this.isPanInteractorEnabled) {
                this.getInteractors().add(this.panInteractor);
            } else {
                this.getInteractors().remove(this.panInteractor);
            }
            this.pcs.firePropertyChange("enablePanInteractor", oldValue, b);
        }
    }

    public boolean getEnablePanInteractor() {
        return this.isPanInteractorEnabled;
    }

    public void setEnableRotateInteractor(boolean b) {
        if (this.isRotateInteractorEnabled != b) {
            boolean oldValue = this.isRotateInteractorEnabled;
            this.isRotateInteractorEnabled = b;
            if (this.isRotateInteractorEnabled) {
                this.getInteractors().add(this.rotateInteractor);
            } else {
                this.getInteractors().remove(this.rotateInteractor);
            }
            this.pcs.firePropertyChange("enableRotateInteractor", oldValue, b);
        }
    }

    public boolean getEnableRotateInteractor() {
        return this.isRotateInteractorEnabled;
    }

    public void setEnableResetTransformInteractor(boolean b) {
        if (this.isResetTransformInteractorEnabled != b) {
            boolean oldValue = this.isResetTransformInteractorEnabled;
            this.isResetTransformInteractorEnabled = b;
            if (this.isResetTransformInteractorEnabled) {
                this.getInteractors().add(this.resetTransformInteractor);
            } else {
                this.getInteractors().remove(this.resetTransformInteractor);
            }
            this.pcs.firePropertyChange("enableResetTransformInteractor", oldValue, b);
        }
    }

    public boolean getEnableResetTransformInteractor() {
        return this.isResetTransformInteractorEnabled;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String newURI) {
        String oldValue = this.uri;
        this.uri = newURI;
        if (this.uri != null) {
            this.loadSVGDocument(this.uri);
        } else {
            DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
            SVGDocument doc = (SVGDocument)impl.createDocument("http://www.w3.org/2000/svg", "svg", null);
            this.setSVGDocument(doc);
        }
        this.pcs.firePropertyChange("URI", oldValue, this.uri);
    }

    protected UserAgent createUserAgent() {
        return new CanvasUserAgent();
    }

    protected JGVTComponent.Listener createListener() {
        return new CanvasSVGListener();
    }

    static {
        SCROLL_RIGHT_ACTION = SCROLL_RIGHT_ACTION;
        SCROLL_LEFT_ACTION = SCROLL_LEFT_ACTION;
        SCROLL_UP_ACTION = SCROLL_UP_ACTION;
        SCROLL_DOWN_ACTION = SCROLL_DOWN_ACTION;
        FAST_SCROLL_RIGHT_ACTION = FAST_SCROLL_RIGHT_ACTION;
        FAST_SCROLL_LEFT_ACTION = FAST_SCROLL_LEFT_ACTION;
        FAST_SCROLL_UP_ACTION = FAST_SCROLL_UP_ACTION;
        FAST_SCROLL_DOWN_ACTION = FAST_SCROLL_DOWN_ACTION;
        ZOOM_IN_ACTION = ZOOM_IN_ACTION;
        ZOOM_OUT_ACTION = ZOOM_OUT_ACTION;
        RESET_TRANSFORM_ACTION = RESET_TRANSFORM_ACTION;
    }

    protected class ToolTipModifier
    implements EventListener {
        protected String toolTip;

        public ToolTipModifier(String toolTip) {
            this.toolTip = toolTip;
        }

        public void handleEvent(Event evt) {
            JSVGCanvas.this.setToolTipText(this.toolTip);
            if (this.toolTip != null) {
                MouseEvent e = new MouseEvent(JSVGCanvas.this, 504, System.currentTimeMillis(), 0, JSVGCanvas.this.locationListener.getLastX(), JSVGCanvas.this.locationListener.getLastY(), 0, false);
                ToolTipManager.sharedInstance().mouseEntered(e);
            }
        }
    }

    protected class LocationListener
    extends MouseMotionAdapter {
        protected int lastX;
        protected int lastY;

        protected LocationListener() {
        }

        public void mouseMoved(MouseEvent evt) {
            this.lastX = evt.getX();
            this.lastY = evt.getY();
        }

        public int getLastX() {
            return this.lastX;
        }

        public int getLastY() {
            return this.lastY;
        }
    }

    protected class CanvasUserAgent
    extends JSVGComponent.BridgeUserAgent
    implements XMLConstants {
        final String TOOLTIP_TITLE_ONLY = "JSVGCanvas.CanvasUserAgent.ToolTip.titleOnly";
        final String TOOLTIP_DESC_ONLY = "JSVGCanvas.CanvasUserAgent.ToolTip.descOnly";
        final String TOOLTIP_TITLE_AND_TEXT = "JSVGCanvas.CanvasUserAgent.ToolTip.titleAndDesc";

        protected CanvasUserAgent() {
            super(JSVGCanvas.this);
        }

        public void handleElement(Element elt, Object data) {
            super.handleElement(elt, data);
            if (elt.getNamespaceURI().equals("http://www.w3.org/2000/svg")) {
                if (elt.getLocalName().equals("title")) {
                    if (this.hasPeerWithTag(elt, "http://www.w3.org/2000/svg", "desc")) {
                        return;
                    }
                    elt.normalize();
                    if (elt.getFirstChild() == null) {
                        return;
                    }
                    String toolTip = elt.getFirstChild().getNodeValue();
                    if (toolTip == null || toolTip.length() == 0) {
                        return;
                    }
                    toolTip = Messages.formatMessage("JSVGCanvas.CanvasUserAgent.ToolTip.titleOnly", new Object[]{this.toFormattedHTML(toolTip)});
                    this.setToolTip((Element)elt.getParentNode(), toolTip);
                } else if (elt.getLocalName().equals("desc")) {
                    elt.normalize();
                    if (elt.getFirstChild() == null) {
                        return;
                    }
                    String toolTip = elt.getFirstChild().getNodeValue();
                    if (toolTip == null || toolTip.length() == 0) {
                        return;
                    }
                    Element titlePeer = this.getPeerWithTag(elt, "http://www.w3.org/2000/svg", "title");
                    if (titlePeer != null) {
                        titlePeer.normalize();
                        toolTip = Messages.formatMessage("JSVGCanvas.CanvasUserAgent.ToolTip.titleAndDesc", new Object[]{this.toFormattedHTML(titlePeer.getFirstChild().getNodeValue()), this.toFormattedHTML(toolTip)});
                    } else {
                        toolTip = Messages.formatMessage("JSVGCanvas.CanvasUserAgent.ToolTip.descOnly", new Object[]{this.toFormattedHTML(toolTip)});
                    }
                    this.setToolTip((Element)elt.getParentNode(), toolTip);
                }
            }
        }

        public String toFormattedHTML(String str) {
            StringBuffer sb = new StringBuffer(str);
            this.replace(sb, '&', "&amp;");
            this.replace(sb, '<', "&lt;");
            this.replace(sb, '>', "&gt;");
            this.replace(sb, '\"', "&quot;");
            this.replace(sb, '\'', "&apos;");
            this.replace(sb, '\n', "<br>");
            return sb.toString();
        }

        /*
         * Unable to fully structure code
         */
        protected void replace(StringBuffer s, char c, String r) {
            v = s.toString() + 1;
            i = v.length();
            if (true) ** GOTO lbl9
            do {
                s.deleteCharAt(i);
                s.insert(i, r);
lbl9:
                // 2 sources

                --i;
            } while ((i = v.lastIndexOf(c, i)) != -1);
        }

        public Element getPeerWithTag(Element elt, String nameSpaceURI, String localName) {
            Element p = (Element)elt.getParentNode();
            if (p == null) {
                return null;
            }
            Node n = p.getFirstChild();
            while (n != null) {
                if (nameSpaceURI.equals(n.getNamespaceURI()) && localName.equals(n.getLocalName()) && n.getNodeType() == 1) {
                    return (Element)n;
                }
                n = n.getNextSibling();
            }
            return null;
        }

        public boolean hasPeerWithTag(Element elt, String nameSpaceURI, String localName) {
            return this.getPeerWithTag(elt, nameSpaceURI, localName) != null;
        }

        public void setToolTip(Element elt, String toolTip) {
            EventTarget target = (EventTarget)((Object)elt);
            elt.normalize();
            target.addEventListener("mouseover", new ToolTipModifier(toolTip), false);
            target.addEventListener("mouseout", new ToolTipModifier(null), false);
            if (JSVGCanvas.this.locationListener == null) {
                JSVGCanvas.this.locationListener = new LocationListener();
                JSVGCanvas.this.addMouseMotionListener(JSVGCanvas.this.locationListener);
            }
        }

        public void displayError(String message) {
            if (JSVGCanvas.this.svgUserAgent != null) {
                super.displayError(message);
            } else {
                JOptionPane pane = new JOptionPane(message, 0);
                JDialog dialog = pane.createDialog(JSVGCanvas.this, "ERROR");
                dialog.setModal(false);
                dialog.show();
            }
        }

        public void displayError(Exception ex) {
            if (JSVGCanvas.this.svgUserAgent != null) {
                super.displayError(ex);
            } else {
                JErrorPane pane = new JErrorPane((Throwable)ex, 0);
                JDialog dialog = pane.createDialog((Component)JSVGCanvas.this, "ERROR");
                dialog.setModal(false);
                dialog.show();
            }
        }
    }

    protected class ScrollDownAction
    extends AbstractAction {
        protected int inc;

        public ScrollDownAction(int inc) {
            this.inc = inc;
        }

        public void actionPerformed(ActionEvent evt) {
            if (JSVGCanvas.this.gvtRoot == null) {
                return;
            }
            AffineTransform at = new AffineTransform(JSVGCanvas.this.getRenderingTransform());
            at.translate(0.0, -this.inc);
            JSVGCanvas.this.setRenderingTransform(at);
        }
    }

    protected class ScrollUpAction
    extends AbstractAction {
        protected int inc;

        public ScrollUpAction(int inc) {
            this.inc = inc;
        }

        public void actionPerformed(ActionEvent evt) {
            if (JSVGCanvas.this.gvtRoot == null) {
                return;
            }
            AffineTransform at = new AffineTransform(JSVGCanvas.this.getRenderingTransform());
            at.translate(0.0, this.inc);
            JSVGCanvas.this.setRenderingTransform(at);
        }
    }

    protected class ScrollLeftAction
    extends AbstractAction {
        protected int inc;

        public ScrollLeftAction(int inc) {
            this.inc = inc;
        }

        public void actionPerformed(ActionEvent evt) {
            if (JSVGCanvas.this.gvtRoot == null) {
                return;
            }
            AffineTransform at = new AffineTransform(JSVGCanvas.this.getRenderingTransform());
            at.translate(this.inc, 0.0);
            JSVGCanvas.this.setRenderingTransform(at);
        }
    }

    protected class ScrollRightAction
    extends AbstractAction {
        protected int inc;

        public ScrollRightAction(int inc) {
            this.inc = inc;
        }

        public void actionPerformed(ActionEvent evt) {
            if (JSVGCanvas.this.gvtRoot == null) {
                return;
            }
            AffineTransform at = new AffineTransform(JSVGCanvas.this.getRenderingTransform());
            at.translate(-this.inc, 0.0);
            JSVGCanvas.this.setRenderingTransform(at);
        }
    }

    protected class ZoomOutAction
    extends AbstractAction {
        protected ZoomOutAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (JSVGCanvas.this.gvtRoot == null) {
                return;
            }
            AffineTransform at = JSVGCanvas.this.getRenderingTransform();
            if (at != null) {
                Dimension dim = JSVGCanvas.this.getSize();
                int x = dim.width / 2;
                int y = dim.height / 2;
                AffineTransform t = AffineTransform.getTranslateInstance(x, y);
                t.scale(0.5, 0.5);
                t.translate(-x, -y);
                t.concatenate(at);
                JSVGCanvas.this.setRenderingTransform(t);
            }
        }
    }

    protected class ZoomInAction
    extends AbstractAction {
        protected ZoomInAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (JSVGCanvas.this.gvtRoot == null) {
                return;
            }
            AffineTransform at = JSVGCanvas.this.getRenderingTransform();
            if (at != null) {
                Dimension dim = JSVGCanvas.this.getSize();
                int x = dim.width / 2;
                int y = dim.height / 2;
                AffineTransform t = AffineTransform.getTranslateInstance(x, y);
                t.scale(2.0, 2.0);
                t.translate(-x, -y);
                t.concatenate(at);
                JSVGCanvas.this.setRenderingTransform(t);
            }
        }
    }

    protected class ResetTransformAction
    extends AbstractAction {
        protected ResetTransformAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            JSVGCanvas.this.setFragmentIdentifier(null);
            JSVGCanvas.this.resetRenderingTransform();
        }
    }

    protected class CanvasSVGListener
    extends JSVGComponent.SVGListener {
        protected CanvasSVGListener() {
            super(JSVGCanvas.this);
        }

        public void documentLoadingStarted(SVGDocumentLoaderEvent e) {
            super.documentLoadingStarted(e);
            JSVGCanvas.this.setToolTipText(null);
        }
    }
}

