/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.RelativePositionProps;

public class BasicLink
extends Inline {
    public static FObj.Maker maker() {
        return new Maker();
    }

    public BasicLink(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
    }

    public String getName() {
        return "fo:basic-link";
    }

    /*
     * WARNING - void declaration
     */
    public int layout(Area area) throws FOPException {
        AreaContainer ac;
        void var3_9;
        boolean linkType;
        AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
        AuralProps mAurProps = this.propMgr.getAuralProps();
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        MarginInlineProps mProps = this.propMgr.getMarginInlineProps();
        RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
        String destination = this.properties.get("internal-destination").getString();
        if (!destination.equals("")) {
            linkType = false;
        } else {
            destination = this.properties.get("external-destination").getString();
            if (!destination.equals("")) {
                linkType = true;
                if (destination.startsWith("url(") && destination.endsWith(")")) {
                    if ((destination = destination.substring(4, destination.length() - 1).trim()).startsWith("\"") && destination.endsWith("\"")) {
                        destination = destination.substring(1, destination.length() - 1);
                    } else if (destination.startsWith("'") && destination.endsWith("'")) {
                        destination = destination.substring(1, destination.length() - 1);
                    }
                }
            } else {
                throw new FOPException("internal-destination or external-destination must be specified in basic-link", this.systemId, this.line, this.column);
            }
        }
        if (this.marker == -1000) {
            String id = this.properties.get("id").getString();
            try {
                area.getIDReferences().initializeID(id, area);
            }
            catch (FOPException e) {
                if (!e.isLocationSet()) {
                    e.setLocation(this.systemId, this.line, this.column);
                }
                throw e;
            }
            this.marker = 0;
        }
        LinkSet ls = new LinkSet(destination, area, (int)var3_9);
        Page p = area.getPage();
        for (ac = area.getNearestAncestorAreaContainer(); ac != null && ac.getPosition() != 1; ac = ac.getNearestAncestorAreaContainer()) {
        }
        if (ac == null) {
            ac = p.getBody().getCurrentColumnArea();
        }
        if (ac == null) {
            throw new FOPException("Couldn't get ancestor AreaContainer when processing basic-link", this.systemId, this.line, this.column);
        }
        int numChildren = this.children.size();
        for (int i = this.marker; i < numChildren; ++i) {
            FONode fo = (FONode)this.children.get(i);
            fo.setLinkSet(ls);
            int status = fo.layout(area);
            if (!Status.isIncomplete(status)) continue;
            this.marker = i;
            return status;
        }
        ls.applyAreaContainerOffsets(ac, area);
        String mergeLinks = System.getProperty("links.merge");
        if (null == mergeLinks || mergeLinks.equalsIgnoreCase("yes")) {
            ls.mergeLinks();
        }
        p.addLinkSet(ls);
        return 1;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new BasicLink(parent, propertyList, systemId, line, column);
        }
    }
}

