/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.StaticContent;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.Page;

public class Footnote
extends FObj {
    public static FObj.Maker maker() {
        return new Maker();
    }

    public Footnote(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
    }

    public String getName() {
        return "fo:footnote";
    }

    public int layout(Area area) throws FOPException {
        FONode inline = null;
        FONode fbody = null;
        if (this.marker == -1000) {
            this.marker = 0;
        }
        int numChildren = this.children.size();
        for (int i = this.marker; i < numChildren; ++i) {
            FONode fo = (FONode)this.children.get(i);
            if (fo instanceof Inline) {
                inline = fo;
                int status = fo.layout(area);
                if (!Status.isIncomplete(status)) continue;
                return status;
            }
            if (inline == null || !(fo instanceof FootnoteBody)) continue;
            fbody = fo;
            if (area instanceof BlockArea) {
                ((BlockArea)area).addFootnote((FootnoteBody)fbody);
                continue;
            }
            Page page = area.getPage();
            Footnote.layoutFootnote(page, (FootnoteBody)fbody, area);
        }
        if (fbody == null) {
            this.log.error("no footnote-body in footnote");
        }
        if (area instanceof BlockArea) {
            // empty if block
        }
        return 1;
    }

    public static boolean layoutFootnote(Page p, FootnoteBody fb, Area area) {
        try {
            int status;
            StaticContent separator;
            BodyAreaContainer bac = p.getBody();
            AreaContainer footArea = bac.getFootnoteReferenceArea();
            footArea.setIDReferences(bac.getIDReferences());
            int basePos = footArea.getCurrentYPosition() - footArea.getHeight();
            int oldHeight = footArea.getHeight();
            if (area != null) {
                footArea.setMaxHeight(area.getMaxHeight() - area.getHeight() + footArea.getHeight());
            } else {
                footArea.setMaxHeight(bac.getMaxHeight() + footArea.getHeight());
            }
            if (!footArea.hasChildren() && (separator = bac.getPage().getPageSequence().getStaticContent("xsl-footnote-separator")) != null) {
                footArea.setIDReferences(bac.getIDReferences());
                separator.layout(footArea, null);
                int diff = footArea.getHeight() - oldHeight;
                if (area != null) {
                    area.setMaxHeight(area.getMaxHeight() - diff);
                }
                if (bac.getFootnoteState() == 0) {
                    AreaContainer ar = bac.getMainReferenceArea();
                    Footnote.decreaseMaxHeight(ar, diff);
                    footArea.setYPosition(basePos + footArea.getHeight());
                }
                basePos = footArea.getCurrentYPosition() - footArea.getHeight();
                oldHeight = footArea.getHeight();
            }
            if (Status.isIncomplete(status = fb.layout(footArea))) {
                return false;
            }
            if (area != null) {
                area.setMaxHeight(area.getMaxHeight() - footArea.getHeight() + oldHeight);
            }
            if (bac.getFootnoteState() == 0) {
                AreaContainer ar = bac.getMainReferenceArea();
                Footnote.decreaseMaxHeight(ar, footArea.getHeight() - oldHeight);
                footArea.setYPosition(basePos + footArea.getHeight());
            }
        }
        catch (FOPException fope) {
            return false;
        }
        return true;
    }

    protected static void decreaseMaxHeight(Area ar, int change) {
        ar.setMaxHeight(ar.getMaxHeight() - change);
        ArrayList children = ar.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Object obj = children.get(i);
            if (!(obj instanceof Area)) continue;
            Area childArea = (Area)obj;
            Footnote.decreaseMaxHeight(childArea, change);
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new Footnote(parent, propertyList, systemId, line, column);
        }
    }
}

