/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.RGBColorValue;
import org.apache.batik.css.engine.value.StringValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.util.CSSConstants;
import org.w3c.dom.css.CSSPrimitiveValue;

/**
 * This interface provides constants for SVG values.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: SVGValueConstants.java,v 1.2 2003/04/11 13:55:57 vhardy Exp $
 */
public interface SVGValueConstants extends ValueConstants {
    
    /**
     * 0 degree
     */
    Value ZERO_DEGREE = new FloatValue(CSSPrimitiveValue.CSS_DEG, 0);

    /**
     * 1
     */
    Value NUMBER_1 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 1);

    /**
     * 4
     */
    Value NUMBER_4 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 4);

    /**
     * 11
     */
    Value NUMBER_11 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 11);

    /**
     * 19
     */
    Value NUMBER_19 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 19);

    /**
     * 20
     */
    Value NUMBER_20 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 20);

    /**
     * 21
     */
    Value NUMBER_21 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 21);

    /**
     * 25
     */
    Value NUMBER_25 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 25);

    /**
     * 30
     */
    Value NUMBER_30 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 30);

    /**
     * 32
     */
    Value NUMBER_32 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 32);

    /**
     * 34
     */
    Value NUMBER_34 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 34);

    /**
     * 35
     */
    Value NUMBER_35 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 35);

    /**
     * 42
     */
    Value NUMBER_42 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 42);

    /**
     * 43
     */
    Value NUMBER_43 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 43);

    /**
     * 45
     */
    Value NUMBER_45 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 45);

    /**
     * 46
     */
    Value NUMBER_46 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 46);

    /**
     * 47
     */
    Value NUMBER_47 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 47);

    /**
     * 50
     */
    Value NUMBER_50 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 50);

    /**
     * 60
     */
    Value NUMBER_60 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 60);

    /**
     * 61
     */
    Value NUMBER_61 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 61);

    /**
     * 63
     */
    Value NUMBER_63 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 63);

    /**
     * 64
     */
    Value NUMBER_64 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 64);

    /**
     * 65
     */
    Value NUMBER_65 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 65);

    /**
     * 69
     */
    Value NUMBER_69 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 69);

    /**
     * 70
     */
    Value NUMBER_70 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 70);

    /**
     * 71
     */
    Value NUMBER_71 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 71);

    /**
     * 72
     */
    Value NUMBER_72 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 72);

    /**
     * 75
     */
    Value NUMBER_75 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 75);

    /**
     * 79
     */
    Value NUMBER_79 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 79);

    /**
     * 80
     */
    Value NUMBER_80 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 80);

    /**
     * 82
     */
    Value NUMBER_82 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 82);

    /**
     * 85
     */
    Value NUMBER_85 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 85);

    /**
     * 87
     */
    Value NUMBER_87 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 87);

    /**
     * 90
     */
    Value NUMBER_90 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 90);

    /**
     * 91
     */
    Value NUMBER_91 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 91);

    /**
     * 92
     */
    Value NUMBER_92 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 92);

    /**
     * 95
     */
    Value NUMBER_95 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 95);

    /**
     * 96
     */
    Value NUMBER_96 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 96);

    /**
     * 99
     */
    Value NUMBER_99 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 99);

    /**
     * 102
     */
    Value NUMBER_102 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 102);

    /**
     * 104
     */
    Value NUMBER_104 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 104);

    /**
     * 105
     */
    Value NUMBER_105 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 105);

    /**
     * 106
     */
    Value NUMBER_106 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 106);

    /**
     * 107
     */
    Value NUMBER_107 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 107);

    /**
     * 112
     */
    Value NUMBER_112 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 112);

    /**
     * 113
     */
    Value NUMBER_113 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 113);

    /**
     * 114
     */
    Value NUMBER_114 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 114);

    /**
     * 119
     */
    Value NUMBER_119 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 119);

    /**
     * 122
     */
    Value NUMBER_122 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 122);

    /**
     * 123
     */
    Value NUMBER_123 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 123);

    /**
     * 124
     */
    Value NUMBER_124 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 124);

    /**
     * 127
     */
    Value NUMBER_127 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 127);

    /**
     * 130
     */
    Value NUMBER_130 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 130);

    /**
     * 133
     */
    Value NUMBER_133 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 133);

    /**
     * 134
     */
    Value NUMBER_134 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 134);

    /**
     * 135
     */
    Value NUMBER_135 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 135);

    /**
     * 136
     */
    Value NUMBER_136 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 136);

    /**
     * 138
     */
    Value NUMBER_138 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 138);

    /**
     * 139
     */
    Value NUMBER_139 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 139);

    /**
     * 140
     */
    Value NUMBER_140 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 140);

    /**
     * 142
     */
    Value NUMBER_142 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 142);

    /**
     * 143
     */
    Value NUMBER_143 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 143);

    /**
     * 144
     */
    Value NUMBER_144 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 144);

    /**
     * 147
     */
    Value NUMBER_147 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 147);

    /**
     * 148
     */
    Value NUMBER_148 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 148);

    /**
     * 149
     */
    Value NUMBER_149 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 149);

    /**
     * 150
     */
    Value NUMBER_150 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 150);

    /**
     * 152
     */
    Value NUMBER_152 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 152);

    /**
     * 153
     */
    Value NUMBER_153 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 153);

    /**
     * 154
     */
    Value NUMBER_154 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 154);

    /**
     * 158
     */
    Value NUMBER_158 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 158);

    /**
     * 160
     */
    Value NUMBER_160 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 160);

    /**
     * 164
     */
    Value NUMBER_164 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 164);

    /**
     * 165
     */
    Value NUMBER_165 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 165);

    /**
     * 169
     */
    Value NUMBER_169 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 169);

    /**
     * 170
     */
    Value NUMBER_170 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 170);

    /**
     * 173
     */
    Value NUMBER_173 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 173);

    /**
     * 175
     */
    Value NUMBER_175 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 175);

    /**
     * 176
     */
    Value NUMBER_176 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 176);

    /**
     * 178
     */
    Value NUMBER_178 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 178);

    /**
     * 179
     */
    Value NUMBER_179 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 179);

    /**
     * 180
     */
    Value NUMBER_180 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 180);

    /**
     * 181
     */
    Value NUMBER_181 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 181);

    /**
     * 182
     */
    Value NUMBER_182 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 182);

    /**
     * 183
     */
    Value NUMBER_183 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 183);

    /**
     * 184
     */
    Value NUMBER_184 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 184);

    /**
     * 185
     */
    Value NUMBER_185 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 185);

    /**
     * 186
     */
    Value NUMBER_186 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 186);

    /**
     * 188
     */
    Value NUMBER_188 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 188);

    /**
     * 189
     */
    Value NUMBER_189 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 189);

    /**
     * 191
     */
    Value NUMBER_191 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 191);

    /**
     * 193
     */
    Value NUMBER_193 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 193);

    /**
     * 196
     */
    Value NUMBER_196 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 196);

    /**
     * 199
     */
    Value NUMBER_199 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 199);

    /**
     * 203
     */
    Value NUMBER_203 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 203);

    /**
     * 204
     */
    Value NUMBER_204 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 204);

    /**
     * 205
     */
    Value NUMBER_205 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 205);

    /**
     * 206
     */
    Value NUMBER_206 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 206);

    /**
     * 208
     */
    Value NUMBER_208 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 208);

    /**
     * 209
     */
    Value NUMBER_209 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 209);

    /**
     * 210
     */
    Value NUMBER_210 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 210);

    /**
     * 211
     */
    Value NUMBER_211 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 211);

    /**
     * 212
     */
    Value NUMBER_212 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 212);

    /**
     * 213
     */
    Value NUMBER_213 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 213);

    /**
     * 214
     */
    Value NUMBER_214 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 214);

    /**
     * 215
     */
    Value NUMBER_215 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 215);

    /**
     * 216
     */
    Value NUMBER_216 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 216);

    /**
     * 218
     */
    Value NUMBER_218 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 218);

    /**
     * 219
     */
    Value NUMBER_219 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 219);

    /**
     * 220
     */
    Value NUMBER_220 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 220);

    /**
     * 221
     */
    Value NUMBER_221 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 221);

    /**
     * 222
     */
    Value NUMBER_222 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 222);

    /**
     * 224
     */
    Value NUMBER_224 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 224);

    /**
     * 225
     */
    Value NUMBER_225 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 225);

    /**
     * 226
     */
    Value NUMBER_226 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 226);

    /**
     * 228
     */
    Value NUMBER_228 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 228);

    /**
     * 230
     */
    Value NUMBER_230 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 230);

    /**
     * 232
     */
    Value NUMBER_232 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 232);

    /**
     * 233
     */
    Value NUMBER_233 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 233);

    /**
     * 235
     */
    Value NUMBER_235 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 235);

    /**
     * 237
     */
    Value NUMBER_237 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 237);

    /**
     * 238
     */
    Value NUMBER_238 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 238);

    /**
     * 239
     */
    Value NUMBER_239 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 239);

    /**
     * 240
     */
    Value NUMBER_240 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 240);

    /**
     * 244
     */
    Value NUMBER_244 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 244);

    /**
     * 245
     */
    Value NUMBER_245 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 245);

    /**
     * 248
     */
    Value NUMBER_248 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 248);

    /**
     * 250
     */
    Value NUMBER_250 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 250);

    /**
     * 251
     */
    Value NUMBER_251 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 251);

    /**
     * 252
     */
    Value NUMBER_252 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 252);

    /**
     * 253
     */
    Value NUMBER_253 = new FloatValue(CSSPrimitiveValue.CSS_NUMBER, 253);


    /**
     * The 'accumulate' keyword.
     */
    Value ACCUMULATE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_ACCUMULATE_VALUE);
    
    /**
     * The 'after-edge' keyword.
     */
    Value AFTER_EDGE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_AFTER_EDGE_VALUE);
    
    /**
     * The 'alphabetic' keyword.
     */
    Value ALPHABETIC_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_ALPHABETIC_VALUE);
    
    /**
     * The 'baseline' keyword.
     */
    Value BASELINE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_BASELINE_VALUE);
    
    /**
     * The 'before-edge' keyword.
     */
    Value BEFORE_EDGE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_BEFORE_EDGE_VALUE);
    
    /**
     * The 'bevel' keyword.
     */
    Value BEVEL_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_BEVEL_VALUE);
    
    /**
     * The 'butt' keyword.
     */
    Value BUTT_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_BUTT_VALUE);
    
    /**
     * The 'central' keyword.
     */
    Value CENTRAL_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_CENTRAL_VALUE);
    
    /**
     * The 'currentcolor' keyword.
     */
    Value CURRENTCOLOR_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_CURRENTCOLOR_VALUE);
    
    /**
     * The 'end' keyword.
     */
    Value END_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_END_VALUE);
    
    /**
     * The 'evenodd' keyword.
     */
    Value EVENODD_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_EVENODD_VALUE);
    
    /**
     * The 'fill' keyword.
     */
    Value FILL_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_FILL_VALUE);
    
    /**
     * The 'fillstroke' keyword.
     */
    Value FILLSTROKE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_FILLSTROKE_VALUE);
    
    /**
     * The 'geometricprecision' keyword.
     */
    Value GEOMETRICPRECISION_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_GEOMETRICPRECISION_VALUE);

    /**
     * The 'hanging' keyword.
     */
    Value HANGING_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_HANGING_VALUE);
    
    /**
     * The 'ideographic' keyword.
     */
    Value IDEOGRAPHIC_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_IDEOGRAPHIC_VALUE);
    
    /**
     * The 'linearRGB' keyword.
     */
    Value LINEARRGB_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LINEARRGB_VALUE);
    
    /**
     * The 'lr' keyword.
     */
    Value LR_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LR_VALUE);
    
    /**
     * The 'lr-tb' keyword.
     */
    Value LR_TB_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LR_TB_VALUE);
    
    /**
     * The 'mathematical' keyword.
     */
    Value MATHEMATICAL_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MATHEMATICAL_VALUE);
    
    /**
     * The 'middle' keyword.
     */
    Value MIDDLE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MIDDLE_VALUE);
    
    /**
     * The 'new' keyword.
     */
    Value NEW_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_NEW_VALUE);
    
    /**
     * The 'miter' keyword.
     */
    Value MITER_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MITER_VALUE);
    
    /**
     * The 'no-change' keyword.
     */
    Value NO_CHANGE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_NO_CHANGE_VALUE);
    
    /**
     * The 'nonzero' keyword.
     */
    Value NONZERO_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_NONZERO_VALUE);

    /**
     * The 'optimizeLegibility' keyword.
     */
    Value OPTIMIZELEGIBILITY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_OPTIMIZELEGIBILITY_VALUE);

    /**
     * The 'optimizeQuality' keyword.
     */
    Value OPTIMIZEQUALITY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_OPTIMIZEQUALITY_VALUE);

    /**
     * The 'optimizeSpeed' keyword.
     */
    Value OPTIMIZESPEED_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_OPTIMIZESPEED_VALUE);

    /**
     * The 'reset-size' keyword.
     */
    Value RESET_SIZE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_RESET_SIZE_VALUE);

    /**
     * The 'rl' keyword.
     */
    Value RL_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_RL_VALUE);
    
    /**
     * The 'rl-tb' keyword.
     */
    Value RL_TB_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_RL_TB_VALUE);
    
    /**
     * The 'round' keyword.
     */
    Value ROUND_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_ROUND_VALUE);
    
    /**
     * The 'square' keyword.
     */
    Value SQUARE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SQUARE_VALUE);
    
    /**
     * The 'sRGB' keyword.
     */
    Value SRGB_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SRGB_VALUE);
    
    /**
     * The 'start' keyword.
     */
    Value START_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_START_VALUE);
    
    /**
     * The 'sub' keyword.
     */
    Value SUB_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SUB_VALUE);
    
    /**
     * The 'super' keyword.
     */
    Value SUPER_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SUPER_VALUE);
    
    /**
     * The 'tb' keyword.
     */
    Value TB_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_TB_VALUE);
    
    /**
     * The 'tb-rl' keyword.
     */
    Value TB_RL_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_TB_RL_VALUE);
    
    /**
     * The 'text-after-edge' keyword.
     */
    Value TEXT_AFTER_EDGE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_TEXT_AFTER_EDGE_VALUE);

    /**
     * The 'text-before-edge' keyword.
     */
    Value TEXT_BEFORE_EDGE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_TEXT_BEFORE_EDGE_VALUE);
    
    /**
     * The 'text-bottom' keyword.
     */
    Value TEXT_BOTTOM_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_TEXT_BOTTOM_VALUE);
    
    /**
     * The 'text-top' keyword.
     */
    Value TEXT_TOP_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_TEXT_TOP_VALUE);
    
    /**
     * The 'use-script' keyword.
     */
    Value USE_SCRIPT_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_USE_SCRIPT_VALUE);

    /**
     * The 'visiblefill' keyword.
     */
    Value VISIBLEFILL_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_VISIBLEFILL_VALUE);
   
    /**
     * The 'visiblefillstroke' keyword.
     */
    Value VISIBLEFILLSTROKE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_VISIBLEFILLSTROKE_VALUE);
   
    /**
     * The 'visiblepainted' keyword.
     */
    Value VISIBLEPAINTED_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_VISIBLEPAINTED_VALUE);
   
    /**
     * The 'visiblestroke' keyword.
     */
    Value VISIBLESTROKE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_VISIBLESTROKE_VALUE);
   
    /**
     * The 'aliceblue' color name.
     */
    Value ALICEBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_ALICEBLUE_VALUE);

    /**
     * The 'antiquewhite' color name.
     */
    Value ANTIQUEWHITE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_ANTIQUEWHITE_VALUE);

    /**
     * The 'aquamarine' color name.
     */
    Value AQUAMARINE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_AQUAMARINE_VALUE);

    /**
     * The 'azure' color name.
     */
    Value AZURE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_AZURE_VALUE);

    /**
     * The 'beige' color name.
     */
    Value BEIGE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_BEIGE_VALUE);

    /**
     * The 'bisque' color name.
     */
    Value BISQUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_BISQUE_VALUE);

    /**
     * The 'blanchedalmond' color name.
     */
    Value BLANCHEDALMOND_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_BLANCHEDALMOND_VALUE);

    /**
     * The 'blueviolet' color name.
     */
    Value BLUEVIOLET_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_BLUEVIOLET_VALUE);

    /**
     * The 'brown' color name.
     */
    Value BROWN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_BROWN_VALUE);

    /**
     * The 'burlywood' color name.
     */
    Value BURLYWOOD_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_BURLYWOOD_VALUE);

    /**
     * The 'cadetblue' color name.
     */
    Value CADETBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_CADETBLUE_VALUE);

    /**
     * The 'chartreuse' color name.
     */
    Value CHARTREUSE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_CHARTREUSE_VALUE);

    /**
     * The 'chocolate' color name.
     */
    Value CHOCOLATE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_CHOCOLATE_VALUE);

    /**
     * The 'coral' color name.
     */
    Value CORAL_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_CORAL_VALUE);

    /**
     * The 'cornflowerblue' color name.
     */
    Value CORNFLOWERBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_CORNFLOWERBLUE_VALUE);

    /**
     * The 'cornsilk' color name.
     */
    Value CORNSILK_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_CORNSILK_VALUE);

    /**
     * The 'crimson' color name.
     */
    Value CRIMSON_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_CRIMSON_VALUE);

    /**
     * The 'cyan' color name.
     */
    Value CYAN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_CYAN_VALUE);

    /**
     * The 'darkblue' color name.
     */
    Value DARKBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKBLUE_VALUE);

    /**
     * The 'darkcyan' color name.
     */
    Value DARKCYAN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKCYAN_VALUE);

    /**
     * The 'darkgoldenrod' color name.
     */
    Value DARKGOLDENROD_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKGOLDENROD_VALUE);

    /**
     * The 'darkgray' color name.
     */
    Value DARKGRAY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKGRAY_VALUE);

    /**
     * The 'darkgreen' color name.
     */
    Value DARKGREEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKGREEN_VALUE);

    /**
     * The 'darkgrey' color name.
     */
    Value DARKGREY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKGREY_VALUE);

    /**
     * The 'darkkhaki' color name.
     */
    Value DARKKHAKI_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKKHAKI_VALUE);

    /**
     * The 'darkmagenta' color name.
     */
    Value DARKMAGENTA_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKMAGENTA_VALUE);

    /**
     * The 'darkolivegreen' color name.
     */
    Value DARKOLIVEGREEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKOLIVEGREEN_VALUE);

    /**
     * The 'darkorange' color name.
     */
    Value DARKORANGE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKORANGE_VALUE);

    /**
     * The 'darkorchid' color name.
     */
    Value DARKORCHID_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKORCHID_VALUE);

    /**
     * The 'darkred' color name.
     */
    Value DARKRED_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKRED_VALUE);

    /**
     * The 'darksalmon' color name.
     */
    Value DARKSALMON_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKSALMON_VALUE);

    /**
     * The 'darkseagreen' color name.
     */
    Value DARKSEAGREEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKSEAGREEN_VALUE);

    /**
     * The 'darkslateblue' color name.
     */
    Value DARKSLATEBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKSLATEBLUE_VALUE);

    /**
     * The 'darkslategray' color name.
     */
    Value DARKSLATEGRAY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKSLATEGRAY_VALUE);

    /**
     * The 'darkslategrey' color name.
     */
    Value DARKSLATEGREY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKSLATEGREY_VALUE);

    /**
     * The 'darkturquoise' color name.
     */
    Value DARKTURQUOISE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKTURQUOISE_VALUE);

    /**
     * The 'darkviolet' color name.
     */
    Value DARKVIOLET_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DARKVIOLET_VALUE);

    /**
     * The 'deeppink' color name.
     */
    Value DEEPPINK_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DEEPPINK_VALUE);

    /**
     * The 'deepskyblue' color name.
     */
    Value DEEPSKYBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DEEPSKYBLUE_VALUE);

    /**
     * The 'dimgray' color name.
     */
    Value DIMGRAY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DIMGRAY_VALUE);

    /**
     * The 'dimgrey' color name.
     */
    Value DIMGREY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DIMGREY_VALUE);

    /**
     * The 'dodgerblue' color name.
     */
    Value DODGERBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_DODGERBLUE_VALUE);

    /**
     * The 'firebrick' color name.
     */
    Value FIREBRICK_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_FIREBRICK_VALUE);

    /**
     * The 'floralwhite' color name.
     */
    Value FLORALWHITE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_FLORALWHITE_VALUE);

    /**
     * The 'forestgreen' color name.
     */
    Value FORESTGREEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_FORESTGREEN_VALUE);

    /**
     * The 'gainsboro' color name.
     */
    Value GAINSBORO_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_GAINSBORO_VALUE);

    /**
     * The 'ghostwhite' color name.
     */
    Value GHOSTWHITE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_GHOSTWHITE_VALUE);

    /**
     * The 'gold' color name.
     */
    Value GOLD_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_GOLD_VALUE);

    /**
     * The 'goldenrod' color name.
     */
    Value GOLDENROD_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_GOLDENROD_VALUE);

    /**
     * The 'greenyellow' color name.
     */
    Value GREENYELLOW_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_GREENYELLOW_VALUE);

    /**
     * The 'grey' color name.
     */
    Value GREY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_GREY_VALUE);

    /**
     * The 'honeydew' color name.
     */
    Value HONEYDEW_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_HONEYDEW_VALUE);

    /**
     * The 'hotpink' color name.
     */
    Value HOTPINK_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_HOTPINK_VALUE);

    /**
     * The 'indianred' color name.
     */
    Value INDIANRED_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_INDIANRED_VALUE);

    /**
     * The 'indigo' color name.
     */
    Value INDIGO_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_INDIGO_VALUE);

    /**
     * The 'ivory' color name.
     */
    Value IVORY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_IVORY_VALUE);

    /**
     * The 'khaki' color name.
     */
    Value KHAKI_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_KHAKI_VALUE);

    /**
     * The 'lavender' color name.
     */
    Value LAVENDER_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LAVENDER_VALUE);

    /**
     * The 'lavenderblush' color name.
     */
    Value LAVENDERBLUSH_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LAVENDERBLUSH_VALUE);

    /**
     * The 'lawngreen' color name.
     */
    Value LAWNGREEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LAWNGREEN_VALUE);

    /**
     * The 'lemonchiffon' color name.
     */
    Value LEMONCHIFFON_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LEMONCHIFFON_VALUE);

    /**
     * The 'lightblue' color name.
     */
    Value LIGHTBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTBLUE_VALUE);

    /**
     * The 'lightcoral' color name.
     */
    Value LIGHTCORAL_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTCORAL_VALUE);

    /**
     * The 'lightcyan' color name.
     */
    Value LIGHTCYAN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTCYAN_VALUE);

    /**
     * The 'lightgoldenrodyellow' color name.
     */
    Value LIGHTGOLDENRODYELLOW_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTGOLDENRODYELLOW_VALUE);

    /**
     * The 'lightgray' color name.
     */
    Value LIGHTGRAY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTGRAY_VALUE);

    /**
     * The 'lightgreen' color name.
     */
    Value LIGHTGREEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTGREEN_VALUE);

    /**
     * The 'lightgrey' color name.
     */
    Value LIGHTGREY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTGREY_VALUE);

    /**
     * The 'lightpink' color name.
     */
    Value LIGHTPINK_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTPINK_VALUE);

    /**
     * The 'lightsalmon' color name.
     */
    Value LIGHTSALMON_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTSALMON_VALUE);

    /**
     * The 'lightseagreen' color name.
     */
    Value LIGHTSEAGREEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTSEAGREEN_VALUE);

    /**
     * The 'lightskyblue' color name.
     */
    Value LIGHTSKYBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTSKYBLUE_VALUE);

    /**
     * The 'lightslategray' color name.
     */
    Value LIGHTSLATEGRAY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTSLATEGRAY_VALUE);

    /**
     * The 'lightslategrey' color name.
     */
    Value LIGHTSLATEGREY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTSLATEGREY_VALUE);

    /**
     * The 'lightsteelblue' color name.
     */
    Value LIGHTSTEELBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTSTEELBLUE_VALUE);

    /**
     * The 'lightyellow' color name.
     */
    Value LIGHTYELLOW_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIGHTYELLOW_VALUE);

    /**
     * The 'limegreen' color name.
     */
    Value LIMEGREEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LIMEGREEN_VALUE);

    /**
     * The 'linen' color name.
     */
    Value LINEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_LINEN_VALUE);

    /**
     * The 'magenta' color name.
     */
    Value MAGENTA_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MAGENTA_VALUE);

    /**
     * The 'mediumaquamarine' color name.
     */
    Value MEDIUMAQUAMARINE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MEDIUMAQUAMARINE_VALUE);

    /**
     * The 'mediumblue' color name.
     */
    Value MEDIUMBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MEDIUMBLUE_VALUE);

    /**
     * The 'mediumorchid' color name.
     */
    Value MEDIUMORCHID_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MEDIUMORCHID_VALUE);

    /**
     * The 'mediumpurple' color name.
     */
    Value MEDIUMPURPLE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MEDIUMPURPLE_VALUE);

    /**
     * The 'mediumseagreen' color name.
     */
    Value MEDIUMSEAGREEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MEDIUMSEAGREEN_VALUE);

    /**
     * The 'mediumslateblue' color name.
     */
    Value MEDIUMSLATEBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MEDIUMSLATEBLUE_VALUE);

    /**
     * The 'mediumspringgreen' color name.
     */
    Value MEDIUMSPRINGGREEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MEDIUMSPRINGGREEN_VALUE);

    /**
     * The 'mediumturquoise' color name.
     */
    Value MEDIUMTURQUOISE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MEDIUMTURQUOISE_VALUE);

    /**
     * The 'mediumvioletred' color name.
     */
    Value MEDIUMVIOLETRED_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MEDIUMVIOLETRED_VALUE);

    /**
     * The 'midnightblue' color name.
     */
    Value MIDNIGHTBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MIDNIGHTBLUE_VALUE);

    /**
     * The 'mintcream' color name.
     */
    Value MINTCREAM_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MINTCREAM_VALUE);

    /**
     * The 'mistyrose' color name.
     */
    Value MISTYROSE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MISTYROSE_VALUE);

    /**
     * The 'moccasin' color name.
     */
    Value MOCCASIN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_MOCCASIN_VALUE);

    /**
     * The 'navajowhite' color name.
     */
    Value NAVAJOWHITE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_NAVAJOWHITE_VALUE);

    /**
     * The 'oldlace' color name.
     */
    Value OLDLACE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_OLDLACE_VALUE);

    /**
     * The 'olivedrab' color name.
     */
    Value OLIVEDRAB_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_OLIVEDRAB_VALUE);

    /**
     * The 'orange' color name.
     */
    Value ORANGE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_ORANGE_VALUE);

    /**
     * The 'orangered' color name.
     */
    Value ORANGERED_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_ORANGERED_VALUE);

    /**
     * The 'orchid' color name.
     */
    Value ORCHID_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_ORCHID_VALUE);

    /**
     * The 'palegoldenrod' color name.
     */
    Value PALEGOLDENROD_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_PALEGOLDENROD_VALUE);

    /**
     * The 'palegreen' color name.
     */
    Value PALEGREEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_PALEGREEN_VALUE);

    /**
     * The 'paleturquoise' color name.
     */
    Value PALETURQUOISE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_PALETURQUOISE_VALUE);

    /**
     * The 'palevioletred' color name.
     */
    Value PALEVIOLETRED_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_PALEVIOLETRED_VALUE);

    /**
     * The 'papayawhip' color name.
     */
    Value PAPAYAWHIP_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_PAPAYAWHIP_VALUE);

    /**
     * The 'peachpuff' color name.
     */
    Value PEACHPUFF_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_PEACHPUFF_VALUE);

    /**
     * The 'peru' color name.
     */
    Value PERU_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_PERU_VALUE);

    /**
     * The 'pink' color name.
     */
    Value PINK_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_PINK_VALUE);

    /**
     * The 'plum' color name.
     */
    Value PLUM_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_PLUM_VALUE);

    /**
     * The 'powderblue' color name.
     */
    Value POWDERBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_POWDERBLUE_VALUE);

    /**
     * The 'purple' color name.
     */
    Value PURPLE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_PURPLE_VALUE);

    /**
     * The 'rosybrown' color name.
     */
    Value ROSYBROWN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_ROSYBROWN_VALUE);

    /**
     * The 'royalblue' color name.
     */
    Value ROYALBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_ROYALBLUE_VALUE);

    /**
     * The 'saddlebrown' color name.
     */
    Value SADDLEBROWN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SADDLEBROWN_VALUE);

    /**
     * The 'salmon' color name.
     */
    Value SALMON_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SALMON_VALUE);

    /**
     * The 'sandybrown' color name.
     */
    Value SANDYBROWN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SANDYBROWN_VALUE);

    /**
     * The 'seagreen' color name.
     */
    Value SEAGREEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SEAGREEN_VALUE);

    /**
     * The 'seashell' color name.
     */
    Value SEASHELL_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SEASHELL_VALUE);

    /**
     * The 'sienna' color name.
     */
    Value SIENNA_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SIENNA_VALUE);

    /**
     * The 'skyblue' color name.
     */
    Value SKYBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SKYBLUE_VALUE);

    /**
     * The 'slateblue' color name.
     */
    Value SLATEBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SLATEBLUE_VALUE);

    /**
     * The 'slategray' color name.
     */
    Value SLATEGRAY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SLATEGRAY_VALUE);

    /**
     * The 'slategrey' color name.
     */
    Value SLATEGREY_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SLATEGREY_VALUE);

    /**
     * The 'snow' color name.
     */
    Value SNOW_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SNOW_VALUE);

    /**
     * The 'springgreen' color name.
     */
    Value SPRINGGREEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_SPRINGGREEN_VALUE);

    /**
     * The 'steelblue' color name.
     */
    Value STEELBLUE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_STEELBLUE_VALUE);

    /**
     * The 'tan' color name.
     */
    Value TAN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_TAN_VALUE);

    /**
     * The 'thistle' color name.
     */
    Value THISTLE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_THISTLE_VALUE);

    /**
     * The 'tomato' color name.
     */
    Value TOMATO_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_TOMATO_VALUE);

    /**
     * The 'turquoise' color name.
     */
    Value TURQUOISE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_TURQUOISE_VALUE);

    /**
     * The 'violet' color name.
     */
    Value VIOLET_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_VIOLET_VALUE);

    /**
     * The 'wheat' color name.
     */
    Value WHEAT_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_WHEAT_VALUE);

    /**
     * The 'whitesmoke' color name.
     */
    Value WHITESMOKE_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_WHITESMOKE_VALUE);

    /**
     * The 'yellowgreen' color name.
     */
    Value YELLOWGREEN_VALUE =
        new StringValue(CSSPrimitiveValue.CSS_IDENT,
                        CSSConstants.CSS_YELLOWGREEN_VALUE);

    /**
     * The 'aliceblue' RGB color.
     */
     Value ALICEBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_240, NUMBER_248, NUMBER_255);

    /**
     * The 'antiquewhite' RGB color.
     */
     Value ANTIQUEWHITE_RGB_VALUE =
         new RGBColorValue(NUMBER_250, NUMBER_235, NUMBER_215);

    /**
     * The 'aquamarine' RGB color.
     */
     Value AQUAMARINE_RGB_VALUE =
         new RGBColorValue(NUMBER_127, NUMBER_255, NUMBER_212);

    /**
     * The 'azure' RGB color.
     */
     Value AZURE_RGB_VALUE =
         new RGBColorValue(NUMBER_240, NUMBER_255, NUMBER_255);

    /**
     * The 'beige' RGB color.
     */
     Value BEIGE_RGB_VALUE =
         new RGBColorValue(NUMBER_245, NUMBER_245, NUMBER_220);

    /**
     * The 'bisque' RGB color.
     */
     Value BISQUE_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_228, NUMBER_196);

    /**
     * The 'blanchedalmond' RGB color.
     */
     Value BLANCHEDALMOND_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_235, NUMBER_205);

    /**
     * The 'blueviolet' RGB color.
     */
     Value BLUEVIOLET_RGB_VALUE =
         new RGBColorValue(NUMBER_138, NUMBER_43, NUMBER_226);

    /**
     * The 'brown' RGB color.
     */
     Value BROWN_RGB_VALUE =
         new RGBColorValue(NUMBER_165, NUMBER_42, NUMBER_42);

    /**
     * The 'burlywood' RGB color.
     */
     Value BURLYWOOD_RGB_VALUE =
         new RGBColorValue(NUMBER_222, NUMBER_184, NUMBER_135);

    /**
     * The 'cadetblue' RGB color.
     */
     Value CADETBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_95, NUMBER_158, NUMBER_160);

    /**
     * The 'chartreuse' RGB color.
     */
     Value CHARTREUSE_RGB_VALUE =
         new RGBColorValue(NUMBER_127, NUMBER_255, NUMBER_0);

    /**
     * The 'chocolate' RGB color.
     */
     Value CHOCOLATE_RGB_VALUE =
         new RGBColorValue(NUMBER_210, NUMBER_105, NUMBER_30);

    /**
     * The 'coral' RGB color.
     */
     Value CORAL_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_127, NUMBER_80);

    /**
     * The 'cornflowerblue' RGB color.
     */
     Value CORNFLOWERBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_100, NUMBER_149, NUMBER_237);

    /**
     * The 'cornsilk' RGB color.
     */
     Value CORNSILK_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_248, NUMBER_220);

    /**
     * The 'crimson' RGB color.
     */
     Value CRIMSON_RGB_VALUE =
         new RGBColorValue(NUMBER_220, NUMBER_20, NUMBER_60);

    /**
     * The 'cyan' RGB color.
     */
     Value CYAN_RGB_VALUE =
         new RGBColorValue(NUMBER_0, NUMBER_255, NUMBER_255);

    /**
     * The 'darkblue' RGB color.
     */
     Value DARKBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_0, NUMBER_0, NUMBER_139);

    /**
     * The 'darkcyan' RGB color.
     */
     Value DARKCYAN_RGB_VALUE =
         new RGBColorValue(NUMBER_0, NUMBER_139, NUMBER_139);

    /**
     * The 'darkgoldenrod' RGB color.
     */
     Value DARKGOLDENROD_RGB_VALUE =
         new RGBColorValue(NUMBER_184, NUMBER_134, NUMBER_11);

    /**
     * The 'darkgray' RGB color.
     */
     Value DARKGRAY_RGB_VALUE =
         new RGBColorValue(NUMBER_169, NUMBER_169, NUMBER_169);

    /**
     * The 'darkgreen' RGB color.
     */
     Value DARKGREEN_RGB_VALUE =
         new RGBColorValue(NUMBER_0, NUMBER_100, NUMBER_0);

    /**
     * The 'darkgrey' RGB color.
     */
     Value DARKGREY_RGB_VALUE =
         new RGBColorValue(NUMBER_169, NUMBER_169, NUMBER_169);

    /**
     * The 'darkkhaki' RGB color.
     */
     Value DARKKHAKI_RGB_VALUE =
         new RGBColorValue(NUMBER_189, NUMBER_183, NUMBER_107);

    /**
     * The 'darkmagenta' RGB color.
     */
     Value DARKMAGENTA_RGB_VALUE =
         new RGBColorValue(NUMBER_139, NUMBER_0, NUMBER_139);

    /**
     * The 'darkolivegreen' RGB color.
     */
     Value DARKOLIVEGREEN_RGB_VALUE =
         new RGBColorValue(NUMBER_85, NUMBER_107, NUMBER_47);

    /**
     * The 'darkorange' RGB color.
     */
     Value DARKORANGE_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_140, NUMBER_0);

    /**
     * The 'darkorchid' RGB color.
     */
     Value DARKORCHID_RGB_VALUE =
         new RGBColorValue(NUMBER_153, NUMBER_50, NUMBER_204);

    /**
     * The 'darkred' RGB color.
     */
     Value DARKRED_RGB_VALUE =
         new RGBColorValue(NUMBER_139, NUMBER_0, NUMBER_0);

    /**
     * The 'darksalmon' RGB color.
     */
     Value DARKSALMON_RGB_VALUE =
         new RGBColorValue(NUMBER_233, NUMBER_150, NUMBER_122);

    /**
     * The 'darkseagreen' RGB color.
     */
     Value DARKSEAGREEN_RGB_VALUE =
         new RGBColorValue(NUMBER_143, NUMBER_188, NUMBER_143);

    /**
     * The 'darkslateblue' RGB color.
     */
     Value DARKSLATEBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_72, NUMBER_61, NUMBER_139);

    /**
     * The 'darkslategray' RGB color.
     */
     Value DARKSLATEGRAY_RGB_VALUE =
         new RGBColorValue(NUMBER_47, NUMBER_79, NUMBER_79);

    /**
     * The 'darkslategrey' RGB color.
     */
     Value DARKSLATEGREY_RGB_VALUE =
         new RGBColorValue(NUMBER_47, NUMBER_79, NUMBER_79);

    /**
     * The 'darkturquoise' RGB color.
     */
     Value DARKTURQUOISE_RGB_VALUE =
         new RGBColorValue(NUMBER_0, NUMBER_206, NUMBER_209);

    /**
     * The 'darkviolet' RGB color.
     */
     Value DARKVIOLET_RGB_VALUE =
         new RGBColorValue(NUMBER_148, NUMBER_0, NUMBER_211);

    /**
     * The 'deeppink' RGB color.
     */
     Value DEEPPINK_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_20, NUMBER_147);

    /**
     * The 'deepskyblue' RGB color.
     */
     Value DEEPSKYBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_0, NUMBER_191, NUMBER_255);

    /**
     * The 'dimgray' RGB color.
     */
     Value DIMGRAY_RGB_VALUE =
         new RGBColorValue(NUMBER_105, NUMBER_105, NUMBER_105);

    /**
     * The 'dimgrey' RGB color.
     */
     Value DIMGREY_RGB_VALUE =
         new RGBColorValue(NUMBER_105, NUMBER_105, NUMBER_105);

    /**
     * The 'dodgerblue' RGB color.
     */
     Value DODGERBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_30, NUMBER_144, NUMBER_255);

    /**
     * The 'firebrick' RGB color.
     */
     Value FIREBRICK_RGB_VALUE =
         new RGBColorValue(NUMBER_178, NUMBER_34, NUMBER_34);

    /**
     * The 'floralwhite' RGB color.
     */
     Value FLORALWHITE_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_250, NUMBER_240);

    /**
     * The 'forestgreen' RGB color.
     */
     Value FORESTGREEN_RGB_VALUE =
         new RGBColorValue(NUMBER_34, NUMBER_139, NUMBER_34);

    /**
     * The 'gainsboro' RGB color.
     */
     Value GAINSBORO_RGB_VALUE =
         new RGBColorValue(NUMBER_220, NUMBER_200, NUMBER_200);

    /**
     * The 'ghostwhite' RGB color.
     */
     Value GHOSTWHITE_RGB_VALUE =
         new RGBColorValue(NUMBER_248, NUMBER_248, NUMBER_255);

    /**
     * The 'gold' RGB color.
     */
     Value GOLD_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_215, NUMBER_0);

    /**
     * The 'goldenrod' RGB color.
     */
     Value GOLDENROD_RGB_VALUE =
         new RGBColorValue(NUMBER_218, NUMBER_165, NUMBER_32);

    /**
     * The 'grey' RGB color.
     */
     Value GREY_RGB_VALUE =
         new RGBColorValue(NUMBER_128, NUMBER_128, NUMBER_128);

    /**
     * The 'greenyellow' RGB color.
     */
     Value GREENYELLOW_RGB_VALUE =
         new RGBColorValue(NUMBER_173, NUMBER_255, NUMBER_47);

    /**
     * The 'honeydew' RGB color.
     */
     Value HONEYDEW_RGB_VALUE =
         new RGBColorValue(NUMBER_240, NUMBER_255, NUMBER_240);

    /**
     * The 'hotpink' RGB color.
     */
     Value HOTPINK_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_105, NUMBER_180);

    /**
     * The 'indianred' RGB color.
     */
     Value INDIANRED_RGB_VALUE =
         new RGBColorValue(NUMBER_205, NUMBER_92, NUMBER_92);

    /**
     * The 'indigo' RGB color.
     */
     Value INDIGO_RGB_VALUE =
         new RGBColorValue(NUMBER_75, NUMBER_0, NUMBER_130);

    /**
     * The 'ivory' RGB color.
     */
     Value IVORY_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_255, NUMBER_240);

    /**
     * The 'khaki' RGB color.
     */
     Value KHAKI_RGB_VALUE =
         new RGBColorValue(NUMBER_240, NUMBER_230, NUMBER_140);

    /**
     * The 'lavender' RGB color.
     */
     Value LAVENDER_RGB_VALUE =
         new RGBColorValue(NUMBER_230, NUMBER_230, NUMBER_250);

    /**
     * The 'lavenderblush' RGB color.
     */
     Value LAVENDERBLUSH_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_240, NUMBER_255);

    /**
     * The 'lawngreen' RGB color.
     */
     Value LAWNGREEN_RGB_VALUE =
         new RGBColorValue(NUMBER_124, NUMBER_252, NUMBER_0);

    /**
     * The 'lemonchiffon' RGB color.
     */
     Value LEMONCHIFFON_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_250, NUMBER_205);

    /**
     * The 'lightblue' RGB color.
     */
     Value LIGHTBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_173, NUMBER_216, NUMBER_230);

    /**
     * The 'lightcoral' RGB color.
     */
     Value LIGHTCORAL_RGB_VALUE =
         new RGBColorValue(NUMBER_240, NUMBER_128, NUMBER_128);

    /**
     * The 'lightcyan' RGB color.
     */
     Value LIGHTCYAN_RGB_VALUE =
         new RGBColorValue(NUMBER_224, NUMBER_255, NUMBER_255);

    /**
     * The 'lightgoldenrodyellow' RGB color.
     */
     Value LIGHTGOLDENRODYELLOW_RGB_VALUE =
         new RGBColorValue(NUMBER_250, NUMBER_250, NUMBER_210);

    /**
     * The 'lightgray' RGB color.
     */
     Value LIGHTGRAY_RGB_VALUE =
         new RGBColorValue(NUMBER_211, NUMBER_211, NUMBER_211);

    /**
     * The 'lightgreen' RGB color.
     */
     Value LIGHTGREEN_RGB_VALUE =
         new RGBColorValue(NUMBER_144, NUMBER_238, NUMBER_144);

    /**
     * The 'lightgrey' RGB color.
     */
     Value LIGHTGREY_RGB_VALUE =
         new RGBColorValue(NUMBER_211, NUMBER_211, NUMBER_211);

    /**
     * The 'lightpink' RGB color.
     */
     Value LIGHTPINK_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_182, NUMBER_193);

    /**
     * The 'lightsalmon' RGB color.
     */
     Value LIGHTSALMON_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_160, NUMBER_122);

    /**
     * The 'lightseagreen' RGB color.
     */
     Value LIGHTSEAGREEN_RGB_VALUE =
         new RGBColorValue(NUMBER_32, NUMBER_178, NUMBER_170);

    /**
     * The 'lightskyblue' RGB color.
     */
     Value LIGHTSKYBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_135, NUMBER_206, NUMBER_250);

    /**
     * The 'lightslategray' RGB color.
     */
     Value LIGHTSLATEGRAY_RGB_VALUE =
         new RGBColorValue(NUMBER_119, NUMBER_136, NUMBER_153);

    /**
     * The 'lightslategrey' RGB color.
     */
     Value LIGHTSLATEGREY_RGB_VALUE =
         new RGBColorValue(NUMBER_119, NUMBER_136, NUMBER_153);

    /**
     * The 'lightsteelblue' RGB color.
     */
     Value LIGHTSTEELBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_176, NUMBER_196, NUMBER_222);

    /**
     * The 'lightyellow' RGB color.
     */
     Value LIGHTYELLOW_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_255, NUMBER_224);

    /**
     * The 'limegreen' RGB color.
     */
     Value LIMEGREEN_RGB_VALUE =
         new RGBColorValue(NUMBER_50, NUMBER_205, NUMBER_50);

    /**
     * The 'linen' RGB color.
     */
     Value LINEN_RGB_VALUE =
         new RGBColorValue(NUMBER_250, NUMBER_240, NUMBER_230);

    /**
     * The 'magenta' RGB color.
     */
     Value MAGENTA_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_0, NUMBER_255);

    /**
     * The 'mediumaquamarine' RGB color.
     */
     Value MEDIUMAQUAMARINE_RGB_VALUE =
         new RGBColorValue(NUMBER_102, NUMBER_205, NUMBER_170);

    /**
     * The 'mediumblue' RGB color.
     */
     Value MEDIUMBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_0, NUMBER_0, NUMBER_205);

    /**
     * The 'mediumorchid' RGB color.
     */
     Value MEDIUMORCHID_RGB_VALUE =
         new RGBColorValue(NUMBER_186, NUMBER_85, NUMBER_211);

    /**
     * The 'mediumpurple' RGB color.
     */
     Value MEDIUMPURPLE_RGB_VALUE =
         new RGBColorValue(NUMBER_147, NUMBER_112, NUMBER_219);

    /**
     * The 'mediumseagreen' RGB color.
     */
     Value MEDIUMSEAGREEN_RGB_VALUE =
         new RGBColorValue(NUMBER_60, NUMBER_179, NUMBER_113);

    /**
     * The 'mediumslateblue' RGB color.
     */
     Value MEDIUMSLATEBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_123, NUMBER_104, NUMBER_238);

    /**
     * The 'mediumspringgreen' RGB color.
     */
     Value MEDIUMSPRINGGREEN_RGB_VALUE =
         new RGBColorValue(NUMBER_0, NUMBER_250, NUMBER_154);

    /**
     * The 'mediumturquoise' RGB color.
     */
     Value MEDIUMTURQUOISE_RGB_VALUE =
         new RGBColorValue(NUMBER_72, NUMBER_209, NUMBER_204);

    /**
     * The 'mediumvioletred' RGB color.
     */
     Value MEDIUMVIOLETRED_RGB_VALUE =
         new RGBColorValue(NUMBER_199, NUMBER_21, NUMBER_133);

    /**
     * The 'midnightblue' RGB color.
     */
     Value MIDNIGHTBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_25, NUMBER_25, NUMBER_112);

    /**
     * The 'mintcream' RGB color.
     */
     Value MINTCREAM_RGB_VALUE =
         new RGBColorValue(NUMBER_245, NUMBER_255, NUMBER_250);

    /**
     * The 'mistyrose' RGB color.
     */
     Value MISTYROSE_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_228, NUMBER_225);

    /**
     * The 'moccasin' RGB color.
     */
     Value MOCCASIN_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_228, NUMBER_181);

    /**
     * The 'navajowhite' RGB color.
     */
     Value NAVAJOWHITE_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_222, NUMBER_173);

    /**
     * The 'oldlace' RGB color.
     */
     Value OLDLACE_RGB_VALUE =
         new RGBColorValue(NUMBER_253, NUMBER_245, NUMBER_230);

    /**
     * The 'olivedrab' RGB color.
     */
     Value OLIVEDRAB_RGB_VALUE =
         new RGBColorValue(NUMBER_107, NUMBER_142, NUMBER_35);

    /**
     * The 'orange' RGB color.
     */
     Value ORANGE_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_165, NUMBER_0);

    /**
     * The 'orangered' RGB color.
     */
     Value ORANGERED_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_69, NUMBER_0);

    /**
     * The 'orchid' RGB color.
     */
     Value ORCHID_RGB_VALUE =
         new RGBColorValue(NUMBER_218, NUMBER_112, NUMBER_214);

    /**
     * The 'palegoldenrod' RGB color.
     */
     Value PALEGOLDENROD_RGB_VALUE =
         new RGBColorValue(NUMBER_238, NUMBER_232, NUMBER_170);

    /**
     * The 'palegreen' RGB color.
     */
     Value PALEGREEN_RGB_VALUE =
         new RGBColorValue(NUMBER_152, NUMBER_251, NUMBER_152);

    /**
     * The 'paleturquoise' RGB color.
     */
     Value PALETURQUOISE_RGB_VALUE =
         new RGBColorValue(NUMBER_175, NUMBER_238, NUMBER_238);

    /**
     * The 'palevioletred' RGB color.
     */
     Value PALEVIOLETRED_RGB_VALUE =
         new RGBColorValue(NUMBER_219, NUMBER_112, NUMBER_147);

    /**
     * The 'papayawhip' RGB color.
     */
     Value PAPAYAWHIP_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_239, NUMBER_213);

    /**
     * The 'peachpuff' RGB color.
     */
     Value PEACHPUFF_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_218, NUMBER_185);

    /**
     * The 'peru' RGB color.
     */
     Value PERU_RGB_VALUE =
         new RGBColorValue(NUMBER_205, NUMBER_133, NUMBER_63);

    /**
     * The 'pink' RGB color.
     */
     Value PINK_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_192, NUMBER_203);

    /**
     * The 'plum' RGB color.
     */
     Value PLUM_RGB_VALUE =
         new RGBColorValue(NUMBER_221, NUMBER_160, NUMBER_221);

    /**
     * The 'powderblue' RGB color.
     */
     Value POWDERBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_176, NUMBER_224, NUMBER_230);

    /**
     * The 'rosybrown' RGB color.
     */
     Value ROSYBROWN_RGB_VALUE =
         new RGBColorValue(NUMBER_188, NUMBER_143, NUMBER_143);

    /**
     * The 'royalblue' RGB color.
     */
     Value ROYALBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_65, NUMBER_105, NUMBER_225);

    /**
     * The 'saddlebrown' RGB color.
     */
     Value SADDLEBROWN_RGB_VALUE =
         new RGBColorValue(NUMBER_139, NUMBER_69, NUMBER_19);

    /**
     * The 'salmon' RGB color.
     */
     Value SALMON_RGB_VALUE =
         new RGBColorValue(NUMBER_250, NUMBER_69, NUMBER_114);

    /**
     * The 'sandybrown' RGB color.
     */
     Value SANDYBROWN_RGB_VALUE =
         new RGBColorValue(NUMBER_244, NUMBER_164, NUMBER_96);

    /**
     * The 'seagreen' RGB color.
     */
     Value SEAGREEN_RGB_VALUE =
         new RGBColorValue(NUMBER_46, NUMBER_139, NUMBER_87);

    /**
     * The 'seashell' RGB color.
     */
     Value SEASHELL_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_245, NUMBER_238);

    /**
     * The 'sienna' RGB color.
     */
     Value SIENNA_RGB_VALUE =
         new RGBColorValue(NUMBER_160, NUMBER_82, NUMBER_45);

    /**
     * The 'skyblue' RGB color.
     */
     Value SKYBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_135, NUMBER_206, NUMBER_235);

    /**
     * The 'slateblue' RGB color.
     */
     Value SLATEBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_106, NUMBER_90, NUMBER_205);

    /**
     * The 'slategray' RGB color.
     */
     Value SLATEGRAY_RGB_VALUE =
         new RGBColorValue(NUMBER_112, NUMBER_128, NUMBER_144);

    /**
     * The 'slategrey' RGB color.
     */
     Value SLATEGREY_RGB_VALUE =
         new RGBColorValue(NUMBER_112, NUMBER_128, NUMBER_144);

    /**
     * The 'snow' RGB color.
     */
     Value SNOW_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_250, NUMBER_250);

    /**
     * The 'springgreen' RGB color.
     */
     Value SPRINGGREEN_RGB_VALUE =
         new RGBColorValue(NUMBER_0, NUMBER_255, NUMBER_127);

    /**
     * The 'steelblue' RGB color.
     */
     Value STEELBLUE_RGB_VALUE =
         new RGBColorValue(NUMBER_70, NUMBER_130, NUMBER_180);

    /**
     * The 'tan' RGB color.
     */
     Value TAN_RGB_VALUE =
         new RGBColorValue(NUMBER_210, NUMBER_180, NUMBER_140);

    /**
     * The 'thistle' RGB color.
     */
     Value THISTLE_RGB_VALUE =
         new RGBColorValue(NUMBER_216, NUMBER_91, NUMBER_216);

    /**
     * The 'tomato' RGB color.
     */
     Value TOMATO_RGB_VALUE =
         new RGBColorValue(NUMBER_255, NUMBER_99, NUMBER_71);

    /**
     * The 'turquoise' RGB color.
     */
     Value TURQUOISE_RGB_VALUE =
         new RGBColorValue(NUMBER_64, NUMBER_224, NUMBER_208);

    /**
     * The 'violet' RGB color.
     */
     Value VIOLET_RGB_VALUE =
         new RGBColorValue(NUMBER_238, NUMBER_130, NUMBER_238);

    /**
     * The 'wheat' RGB color.
     */
     Value WHEAT_RGB_VALUE =
         new RGBColorValue(NUMBER_245, NUMBER_222, NUMBER_179);

    /**
     * The 'whitesmoke' RGB color.
     */
     Value WHITESMOKE_RGB_VALUE =
         new RGBColorValue(NUMBER_245, NUMBER_245, NUMBER_245);

    /**
     * The 'yellowgreen' RGB color.
     */
     Value YELLOWGREEN_RGB_VALUE =
         new RGBColorValue(NUMBER_154, NUMBER_205, NUMBER_50);

}
