/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.dom.svg;

import org.apache.batik.dom.AbstractDocument;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGSetElement;

/**
 * This class implements {@link SVGSetElement}.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: SVGOMSetElement.java,v 1.2 2003/04/11 13:56:16 vhardy Exp $
 */
public class SVGOMSetElement
    extends    SVGOMAnimationElement
    implements SVGSetElement {

    /**
     * Creates a new SVGOMSetElement object.
     */
    protected SVGOMSetElement() {
    }

    /**
     * Creates a new SVGOMSetElement object.
     * @param prefix The namespace prefix.
     * @param owner The owner document.
     */
    public SVGOMSetElement(String prefix, AbstractDocument owner) {
        super(prefix, owner);

    }

    /**
     * <b>DOM</b>: Implements {@link Node#getLocalName()}.
     */
    public String getLocalName() {
        return SVG_SET_TAG;
    }

    /**
     * Returns a new uninitialized instance of this object's class.
     */
    protected Node newNode() {
        return new SVGOMSetElement();
    }
}
