/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included with this distribution in  *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.batik.ext.awt.image.spi;

import org.apache.batik.ext.awt.image.renderable.Filter;

/**
 * This interface is to be used to provide alternate ways of 
 * generating a placeholder image when the ImageTagRegistry
 * fails to handle a given reference.
 */
public interface BrokenLinkProvider {

    /**
     * The image returned by getBrokenLinkImage should always
     * return some value when queried for the BROKEN_LINK_PROPERTY.
     * This allows code the determine if the image is the 'real'
     * image or the broken link image, which may be important for
     * the application of profiles etc.
     */
    public static final String BROKEN_LINK_PROPERTY = 
        "org.apache.batik.BrokenLinkImage";

    /**
     * This method is responsbile for constructing an image that will
     * represent the missing image in the document.  This method
     * recives information about the reason a broken link image is
     * being requested in the <tt>code</tt> and <tt>params</tt>
     * parameters. These parameters may be used to generate nicely
     * localized messages for insertion into the broken link image, or
     * for selecting the broken link image returned.
     *
     * @param base The object to use for Message decoding.
     * @param code This is the reason the image is unavailable should
     *             be taken from ErrorConstants.
     * @param params This is more detailed information about
     *        the circumstances of the failure.  */
    public Filter getBrokenLinkImage(Object base,
                                     String code, Object[] params);
}
