package org.bouncycastle.ocsp;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.bouncycastle.asn1.ocsp.CertStatus;
import org.bouncycastle.asn1.ocsp.RevokedInfo;
import org.bouncycastle.asn1.ocsp.SingleResponse;
import org.bouncycastle.asn1.x509.X509Extensions;

public class SingleResp
{
    SingleResponse  resp;

    public SingleResp(
        SingleResponse  resp)
    {
        this.resp = resp;
    }

    public CertificateID getCertID()
    {
        return new CertificateID(resp.getCertID());
    }

    public Object getCertStatus()
    {
        CertStatus  s = resp.getCertStatus();

        if (s.getTagNo() == 0)
        {
            return null;            // good
        }
        else if (s.getTagNo() == 1)
        {
            return new RevokedStatus(RevokedInfo.getInstance(s.getStatus()));
        }

        return new UnknownStatus();
    }

    public Date getThisUpdate()
    {
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmssz");

        return dateF.parse(resp.getThisUpdate().getTime(), new ParsePosition(0));
    }

    /**
     * return the NextUpdate value - note: this is an optional field so may
     * be returned as null.
     */
    public Date getNextUpdate()
    {
        if (resp.getNextUpdate() == null)
        {
            return null;
        }

        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmssz");

        return dateF.parse(resp.getNextUpdate().getTime(), new ParsePosition(0));
    }

    public X509Extensions getSingleExtensions()
    {
        return resp.getSingleExtensions();
    }
}
